<?php
add_action('init',create_function('','global $spec_commenting;$spec_commenting =& new spec_commenting();'));

if (!class_exists('spec_commenting')) {
	class spec_commenting {

		function spec_commenting (){
			if (!defined(THEMENAME))
				define(THEMENAME,'threaded-comments');
			load_theme_textdomain(THEMENAME);

			add_action('wp_head',array($this,'css'));

			// If we're in WP >= 27 then we'll add some JQ to the comments.
			global $wp_version;
			if (version_compare($wp_version, '2.7', 'ge')) {
				add_action('wp',array($this,'before_headers'));
				add_action('admin_menu', array($this, 'add_options_page'));
				$defaultOptions = array('comments_nest_depth' => 1,);
				$this->options = array_merge($defaultOptions, (array)get_option(__CLASS__));
			}
		}

		function before_headers(){
			if(function_exists('wp_list_comments') && is_singular()) {
				wp_enqueue_script ('commenting',get_bloginfo('template_url').'/comments/commenting.min.js',array('jquery'));

				wp_localize_script('commenting','commentingL10n',array(
					'trackbackShowText' => __('Show trackbacks',THEMENAME),
					'trackbackHideText' => __('Hide trackbacks',THEMENAME),
					'replyHideMany' => __('Hide %count% replies to %name% comment',THEMENAME),
					'replyShowMany' => __('View %count% replies to %name% comment',THEMENAME),
					'replyHideOne' => __('Hide the reply to %name% comment',THEMENAME),
					'replyShowOne' => __('View the reply to %name% comment',THEMENAME),
					'nestDepth' => $this->options['comments_nest_depth'] // The depth at which to start collapsing comments.
				));
			}
		}

		function css(){
			if (is_singular()) {
				?><link rel="stylesheet" href="<?php bloginfo('template_url');?>/comments/comments.css" type="text/css" media="screen" /><?php
			}
		}

		function add_options_page() {
			register_setting(__CLASS__, __CLASS__, array($this, 'validate_option'));
			add_theme_page(__('Comments', THEMENAME), __('Comments', THEMENAME), 'manage_options', THEMENAME, array($this, 'options_page'));
		}

		function validate_option($options) {
			$options['comments_nest_depth'] = intval($options['comments_nest_depth']) > 0 || intval($options['comments_nest_depth']) < 11 ? intval($options['comments_nest_depth']) : 1;
			return $options;
		}

		function options_page() {?>
		<div class="wrap">
			<h2><?php _e('Threaded comment options', THEMENAME)?></h2>
			<form method="post" action="options.php">
				<?php settings_fields(__CLASS__); ?>

				<?php $options = get_option(__CLASS__); ?>
				<div id="poststuff" class="metabox-holder">
					<div id="post-body-content">
						<div class="stuffbox">
							<h3><?php _e('Rollup Depth',THEMENAME);?></h3>
							<div class="inside">
								<p>
								<select name="<?php echo __CLASS__;?>[comments_nest_depth]" id="<?php echo __CLASS__;?>_comments_nest_depth" style="width:200px;">
									<option value="1"<?php echo intval($options['comments_nest_depth']) == 1 ? ' selected="selected"' : '';?>>1</option>
									<option value="2"<?php echo intval($options['comments_nest_depth']) == 2 ? ' selected="selected"' : '';?>>2</option>
									<option value="3"<?php echo intval($options['comments_nest_depth']) == 3 ? ' selected="selected"' : '';?>>3</option>
									<option value="4"<?php echo intval($options['comments_nest_depth']) == 4 ? ' selected="selected"' : '';?>>4</option>
									<option value="5"<?php echo intval($options['comments_nest_depth']) == 5 ? ' selected="selected"' : '';?>>5</option>
									<option value="6"<?php echo intval($options['comments_nest_depth']) == 6 ? ' selected="selected"' : '';?>>6</option>
									<option value="7"<?php echo intval($options['comments_nest_depth']) == 7 ? ' selected="selected"' : '';?>>7</option>
									<option value="8"<?php echo intval($options['comments_nest_depth']) == 8 ? ' selected="selected"' : '';?>>8</option>
									<option value="9"<?php echo intval($options['comments_nest_depth']) == 9 ? ' selected="selected"' : '';?>>9</option>
									<option value="10"<?php echo intval($options['comments_nest_depth']) == 10 ? ' selected="selected"' : '';?>>10</option>
								</select>
								</p>
								<p style="max-width:520px;">
									<label for="<?php echo __CLASS__;?>_comments_nest_depth">
									<?php _e('This is the depth at which comments require a click to see replies. JavaScript is used to hide comments greater than this depth and replaces them with a toggle to click on to show them.',THEMENAME);  ?>
									</label>
								</p>
							</div>
							<div id="major-publishing-actions">
								<div id="publishing-action">
								<input type="submit" class="button-primary" value="<?php _e('Save', THEMENAME) ?>" /></div>
								<div class="clear"></div>
							</div>
						</div>
					</div>
				</div>
			</form>
		</div>
		<?php
		}
	}
}

?>